
#################### packages ####################

library(splines)
library(np)
library("AER")

#################### ohs.res ####################

# code a function that can give residuals from Ozabaci, Henderson, and Su's (2014) procedure #
# in the function, the 1st variable is the dependent variable, the 2nd is endogenous, and the 3rd is IV #

ohs.res <- function(data){

Dat=data

########## 1st stage ##########

Dat.1=Dat[-c(1)]
iv=Dat.1[c(2)]

iv=as.matrix(iv)
n=nrow(Dat)
knots=floor(2*n^(1/5)+3)
iv.s=bs(iv,df=knots)

dat.11=Dat.1[-c(2)]
dat.1=cbind(iv.s,dat.11)

ols=lm(x1~.,data=dat.1)
res=residuals(ols)
res=as.matrix(res)

########## 2nd stage ##########

Dat.2=Dat[-c(3)]
en=Dat.2[c(2)]

en=as.matrix(en)
en.s=bs(en,df=knots)

dat.22=Dat.2[-c(2)]
dat.2=cbind(res,en.s,dat.22)
ols=lm(y~.,data=dat.2)
fit=fitted.values(ols)
fit=as.matrix(fit)

nn=ncol(en.s)
coef=coefficients(ols)[3:(3+nn-1)]
coef[is.na(coef)]=0
coef=as.matrix(coef)

x=dat.2[c(2:(2+nn-1))]
x=as.matrix(x)

fit.x=x%*%coef

y=dat.2$y
y=as.matrix(y)

y.s=y-fit+fit.x

########## 3th stage ##########

y.s=as.numeric(y.s)
en=as.numeric(en)

bwll=npregbw(y.s~en,regtype="ll",residuals=TRUE,bwmethod="cv.ls")
#bwll=npregbw(y.s~en,regtype="ll",residuals=TRUE,bwmethod="cv.aic")#
# only for two cases: 5 year window and low ethnic polarization #
h=bwll$bw
llls=npreg(bws=bwll,regtype="ll",residuals=TRUE)
res=residuals(llls)
res=as.matrix(res)

return.list <- list(band=h,resid=res)
return(return.list)

}

#################### ohs.res.b ####################

# code a function that can give residuals from Ozabaci, Henderson, and Su's (2014) procedure with a specific bandwidth #
# in the function, the 1st variable is the dependent variable, the 2nd is endogenous, and the 3rd is IV # 

ohs.res.b <- function(data,bandwidth){

Dat=data

########## 1st stage ##########

Dat.1=Dat[-c(1)]
iv=Dat.1[c(2)]

iv=as.matrix(iv)
n=nrow(Dat)
knots=floor(2*n^(1/5)+3)
iv.s=bs(iv,df=knots)

dat.11=Dat.1[-c(2)]
dat.1=cbind(iv.s,dat.11)

ols=lm(x1~.,data=dat.1)
res=residuals(ols)
res=as.matrix(res)

########## 2nd stage ##########

Dat.2=Dat[-c(3)]
en=Dat.2[c(2)]

en=as.matrix(en)
en.s=bs(en,df=knots)

dat.22=Dat.2[-c(2)]
dat.2=cbind(res,en.s,dat.22)
ols=lm(y~.,data=dat.2)
fit=fitted.values(ols)
fit=as.matrix(fit)

nn=ncol(en.s)
coef=coefficients(ols)[3:(3+nn-1)]
coef[is.na(coef)]=0
coef=as.matrix(coef)

x=dat.2[c(2:(2+nn-1))]
x=as.matrix(x)

fit.x=x%*%coef

y=dat.2$y
y=as.matrix(y)

y.s=y-fit+fit.x

########## 3th stage ##########

y.s=as.numeric(y.s)
en=as.numeric(en)

bwll=npregbw(y.s~en,regtype="ll",residuals=TRUE,bandwidth.compute=FALSE,bws=bandwidth)
llls=npreg(bws=bwll,regtype="ll",residuals=TRUE)
res=residuals(llls)
res=as.matrix(res)

return.list <- list(resid=res)
return(return.list)

}

#################### tsls.res ####################

# code a function that can give residuals and fitted values from two stage least squares #
# in the function, the 1st variable is the dependent variable, the 2nd and 3rd are endogenous, and the 4th, 5th, and 6th are IVs # 

tsls.res <- function(data){

Dat=data

########## 2nd stage ##########

tsls=ivreg(y~.-x3-x4-x5|.-x1-x2+x3+x4+x5,data=Dat)

res.1=residuals(tsls)
res.1=as.matrix(res.1)

fit.1=fitted.values(tsls)
fit.1=as.matrix(fit.1)

coef.1=coefficients(tsls)[2:3]
coef.1=as.matrix(coef.1)
x.1=Dat[c(2,3)]
x.1=as.matrix(x.1)
fit.1.x=x.1%*%coef.1

########## 1st stage ##########

ols.1=lm(x1~.-y-x2,data=Dat)
res.2=residuals(ols.1)
res.2=as.matrix(res.2)
fit.2=fitted.values(ols.1)
fit.2=as.matrix(fit.2)

ols.2=lm(x2~.-y-x1,data=Dat)
res.3=residuals(ols.2)
res.3=as.matrix(res.3)
fit.3=fitted.values(ols.2)
fit.3=as.matrix(fit.3)

return.list <- list(resid1=res.1,resid2=res.2,resid3=res.3,fitted1=fit.1,fitted2=fit.2,fitted3=fit.3,fitted11=fit.1.x,coef11=coef.1)
return(return.list)

}
